namespace Baki_i_Srecko
{ 
    public class Pomeraj
    {
        public double X;
        public double Y;
        public Pomeraj(double x, double y)
        {
            X = x;
            Y = y;
        }
    }

    public class Stanje
    {
        public int Indeks;
        public double SumX;
        public double SumY;
        public List<int> IzabraniPomeraji;

        public Stanje(int index, double sumX, double sumY, List<int> izabraniPomeraji)
        {
            Indeks = index;
            SumX = sumX;
            SumY = sumY;
            IzabraniPomeraji = izabraniPomeraji;
        }
    }

    internal class Program
    {
        public static void UnosPodataka(out int n, out Pomeraj[] pomeraji)
        {
            n = int.Parse(Console.ReadLine());

            pomeraji = new Pomeraj[n];

            for (int i = 0; i < n; i++)
            {
                double[] input = Array.ConvertAll(Console.ReadLine().Split(), double.Parse);
                pomeraji[i] = new Pomeraj(input[0], input[1]);
            }
        }

        public static List<int> BFS(int n, Pomeraj[] pomeraj)
        {
            List<int> izabraniPomeraji = new List<int>();
            double najvecaDistanca = -1;

            Queue<Stanje> queue = new Queue<Stanje>();
            queue.Enqueue(new Stanje(0, 0, 0, new List<int>()));

            while (queue.Count > 0)
            {
                Stanje stanje = queue.Dequeue();

                // Stigli do kraja
                if (stanje.Indeks == n)
                {
                    double distanca = stanje.SumX * stanje.SumX + stanje.SumY * stanje.SumY;
                    if (distanca > najvecaDistanca)
                    {
                        najvecaDistanca = distanca;
                        izabraniPomeraji = stanje.IzabraniPomeraji;
                    }

                    continue;
                }

                // Prva opcija: ne koristimo pomeraj
                queue.Enqueue(new Stanje(stanje.Indeks + 1, stanje.SumX, stanje.SumY, stanje.IzabraniPomeraji));

                // Druga opcija: koristimo pomeraj
                double nx = stanje.SumX + pomeraj[stanje.Indeks].X;
                double ny = stanje.SumY + pomeraj[stanje.Indeks].Y;

                List<int> novaLista = new List<int>(stanje.IzabraniPomeraji) { stanje.Indeks + 1};
                queue.Enqueue(new Stanje(stanje.Indeks + 1, nx, ny, novaLista));
            }

            return izabraniPomeraji;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out Pomeraj[] pomeraji);

            // Izracunavanje maksimalne distance
            List<int> rezultat = BFS(n, pomeraji);

            Console.WriteLine(string.Join(' ', rezultat));
        }
    }
}